/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityLavaProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VolcaniteAmulet
extends ItemPE
implements IProjectileShooter,
IPedestalItem,
IFireProtector {
    public VolcaniteAmulet(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.m_41777_();
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        if (player != null && !level.f_46443_ && PlayerHelper.hasEditPermission((ServerPlayer)player, pos) && VolcaniteAmulet.consumeFuel(player, stack, 32L, true)) {
            Optional capability;
            BlockEntity blockEntity = WorldHelper.getBlockEntity((BlockGetter)level, pos);
            Direction sideHit = ctx.m_43719_();
            if (blockEntity != null && (capability = blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideHit).resolve()).isPresent()) {
                ((IFluidHandler)capability.get()).fill(new FluidStack((Fluid)Fluids.f_76195_, 1000), IFluidHandler.FluidAction.EXECUTE);
                return InteractionResult.SUCCESS;
            }
            WorldHelper.placeFluid((ServerPlayer)player, level, pos, sideHit, Fluids.f_76195_, false);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean shootProjectile(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        EntityLavaProjectile ent = new EntityLavaProjectile(player, player.m_20193_());
        ent.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
        player.m_20193_().m_7967_((Entity)ent);
        return true;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltips, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        tooltips.add((Component)PELang.TOOLTIP_VOLCANITE_1.translate(ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)));
        tooltips.add((Component)PELang.TOOLTIP_VOLCANITE_2.translate(new Object[0]));
        tooltips.add((Component)PELang.TOOLTIP_VOLCANITE_3.translate(new Object[0]));
        tooltips.add((Component)PELang.TOOLTIP_VOLCANITE_4.translate(new Object[0]));
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.f_46443_ && ProjectEConfig.server.cooldown.pedestal.volcanite.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                LevelData levelData = level.m_6106_();
                if (levelData instanceof ServerLevelData) {
                    ServerLevelData worldInfo = (ServerLevelData)levelData;
                    worldInfo.m_6399_(0);
                    worldInfo.m_6398_(0);
                    worldInfo.m_5565_(false);
                    worldInfo.m_5557_(false);
                }
                ((IDMPedestal)pedestal).setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.volcanite.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown();
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.volcanite.get() != -1) {
            list.add((Component)PELang.PEDESTAL_VOLCANITE_1.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_VOLCANITE_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.volcanite.get())));
        }
        return list;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, ServerPlayer player) {
        return true;
    }
}

